using System;
using System.Collections.Generic;
using System.Text;
using Intemi.InTrees.Implements;

namespace Intemi.InTrees
{
    public class DTVConfig : IConfiguration
    {
        private IPruning pruning = null;
        public IPruning Pruning
        {
            get { return pruning; }
            set { pruning = value; }
        }

        public void Configure(ConfigBuilder confBuilder)
        {
            confBuilder.DeclareInput("Test dataset",
                new Type[] { typeof(IDataTable), typeof(ITargets) }, false);
            confBuilder.DeclareInput("Train dataset",
                new Type[] { typeof(IDataTable), typeof(ITargets) }, false);
            confBuilder.DeclareInput("Decision tree",
                new Type[] { typeof(DecisionTree) }, false);
            confBuilder.DeclareOutput("Pruning table","PruningTable",
                new Type[] { typeof(IPruningTable) });
        }
        public object Clone() 
        {
            DTVConfig dtvConfig = new DTVConfig();
            dtvConfig.Pruning = this.Pruning;
            return (dtvConfig); 
        }
    }
    [Machine("DTValidator", typeof(DTVConfig))]
    public class DTValidator : IMachine
    {
        IMachineBase MachineBase;
        public void SetMachineBase(IMachineBase mb) 
        { 
            MachineBase = mb; 
        }

        private IPruningTable pruningTable;
        public IPruningTable PruningTable
        {
            get { return pruningTable; }
            //set { tree = value; }
        }

        public void Run(ref bool shouldTerminate)
        {
            IDataTable testDT = MachineBase.GetInput("Test dataset") as IDataTable;
            IDataTable trainDT = MachineBase.GetInput("Train dataset") as IDataTable;
            DecisionTree tree = MachineBase.GetInput("Decision tree") as DecisionTree;

            DTVConfig cnf = MachineBase.ConfBase.Configuration as DTVConfig;
          
            if (cnf.Pruning != null)
            {
                IPruning pruning = cnf.Pruning;
                this.pruningTable = pruning.BuildPruningTable(tree, trainDT, testDT,ref shouldTerminate);
            }
            else
            {
                throw new ExceptionIncorectPruningParameters();
            }
                      
            ////MachineBase.CloseInput("Test dataset");
            ////MachineBase.CloseInput("Train dataset");
            ////MachineBase.CloseInput("Decision tree");
        }
    }
}
